% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % System name
 
    system='2d P-N model';
 
    % The absolute path to save the result files
 
    filepath=pwd;
 
    % The dimension of P-N model: 1 or 2 

    misdim=2;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
 
    % % the data of GSFE (unit: J/m2) and normalized disregistry vector (unit: 1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[-0.78523	101.03975	347.02692	606.18605	790.16897	863.13074	814.40402	643.82659	381.88456	133.40676	38.66211	92.4533	158.33824	147.41288	64.70745	0;
61.49732	112.52727	323.15197	567.03588	745.63549	817.50857	767.78825	598.81415	349.68746	137.96499	94.83135	180.64693	258.05855	250.14545	159.03676	63.21531;
213.2307	144.95022	257.44463	456.24198	616.81913	682.6754	630.48193	470.86832	265.21719	155.44066	226.02577	373.50858	473.45404	470.167	364.50539	210.60861;
375.81951	191.33734	169.94113	292.71412	422.95829	476.50685	422.70098	283.16903	155.37563	183.30328	363.9572	560.96174	677.3683	677.80042	562.37207	363.8635;
491.67578	232.54322	91.69324	128.94012	221.25847	260.59183	207.44743	97.65202	60.27648	207.8292	460.57506	683.78017	808.35365	810.56669	691.86318	470.89489;
530.92174	249.12389	60.26599	55.81474	129.08067	162.10565	108.46829	15.98003	22.61495	217.5449	492.2876	722.86601	849.99654	852.69484	733.33616	507.17405;
486.33512	230.84551	92.20158	132.10411	227.9738	269.68243	213.60758	101.07611	60.85683	206.09653	455.58611	675.97894	799.70986	801.67817	683.29421	467.17362;
368.31475	189.10892	172.02552	300.53702	437.02245	493.9986	438.03283	292.42184	158.49136	183.23545	359.41645	550.12589	663.21883	662.50492	549.66859	357.85928;
207.73131	143.54898	260.69951	466.42755	632.51807	700.88874	646.77591	481.70976	270.28376	157.09712	223.81832	365.70455	460.96872	456.28253	353.53808	205.54554;
59.01578	110.69811	324.84199	574.16865	755.7001	829.23243	778.09759	605.50501	353.03954	138.946	96.07807	179.34707	253.82476	243.95104	153.97718	61.26867;
-3.35417	100.01469	346.71367	605.57283	790.5018	864.6928	815.32979	642.84698	381.4874	132.57119	39.48789	94.4244	158.87244	147.20382	63.06288	-1.42991]'/1E3;

    % % Which trial function of disregistry vector to employ (>=-1)
    
    Nmis=0;     
     
    % % The value of Burgers vector (unit: A)
 
    BurVect=2.570;
 
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=47.91;
    poisson_ratio=0.345;
 
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=-1)
    
    fitcut=0;
    
    % % Mode of P-N models: CCPN (1) or SVPN (2)

    pnmode=2;
    
    % % Interplanar distance ?x (unit: A)
    
    Inpas=1/2*BurVect;
    
    % % The reference position x_m is defined as x_m=m?x+dax for SVPN model
    %   (m=0, 1, 2, , ?)
 
    dax=0.0;
 
   % % Matrix of the lower and upper bounds, and initial values of each unknown 
   %   variable ([Lower bound, Upper bound, StartPoint]) 
  
    Xcoef_range=[0.00, 1.00, 0.200];
    Xdist_range=[-50.00, 50.00, 8.00];
    Xwid_range=[0.00,20.00, 1.00];
    dx_range=[-5.00,5.00, 0.00];
    
    % % The minimization method for 2D P-N model: PSO ('2d_PSO') or GA ('2d_GA')
 
    minimethod='2d_PSO';   
    
    % % PSO or GA Parameters
 
        % % % Size of the population and maximum number of iteration
 
        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
    
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
    
        % % % >>> For edge dislocation of FCC and HCP structures
 
        % LatC_spacing=sqrt(2/3)/2*BurVect;
        % [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
        %                                -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);
 
        % % % >>> For screw dislocation of FCC structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
        % % % >>> For screw dislocation of HCP structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
    % % Which component of the dislocation to calculate: x or z
    
    % dis_component_xz='x';
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------
 
    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='FALSE';
    
    % % Plotting the position-dependent solute/dislocation interaction energy
    %   ('TRUE') or NOT ('FALSE')
    
    % Einteraction_Plot='TRUE';
    
    % % The input volumetric misfit (eb_input) and slip misfit (es_input) parameters
    
    % eb_input=[];
    % es_input=[];
 
    % % The interlayer spacing along FCC [111] or HCP [0001] direction
 
    % LatC_spacing=[];

        % % % >>> for FCC structure

        % LatC_spacing=sqrt(2/3)/2*BurVect; 
 
    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    % coefV=[];

        % % % >>> for FCC structure
    
        % coefV=3/4*(sqrt(2)*BurVect)^3;

    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    % wc_range=[];        
        
    % % Concentration of solute atom
 
    % solute_concentration=1;
